//
//  SupplierOrdersViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 10/31/18.
//  Copyright © 2018 juger. All rights reserved.
//

import Autotech


class SupplierOrdersViewController: ATEntityListVC
{
    override func getOperationKey() -> String
    {
        return "Supplier Orders"
    }
    
    override func getCellReuseIdentifier() -> String
    {
        return "supplierOrdersMainTableCell"
    }
    
    override func dataRequestEndPointPostfix() -> String {
        return supplierOrdersURLPostfix
    }
    
    
    override func getSegueID() -> String
    {
        return "goToSupplierOrderDetails"
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableView.register(UINib(nibName : "SupplierOrdersMainTableCell" , bundle : nil), forCellReuseIdentifier: getCellReuseIdentifier())
        
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == getSegueID()
        {
            let index = sender as! Int
            let destination = segue.destination as! SupplierOrderDetailsViewController
            destination.dataToView = self.dataToView![index] as! NSDictionary
        }
        super.prepare(for: segue, sender: sender)
    }
}
